/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.plainsmobs;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemCustomFood;
import com.lycanitesmobs.core.item.ItemTreat;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import com.lycanitesmobs.core.spawning.SpawnTypeSky;
import com.lycanitesmobs.plainsmobs.CommonSubProxy;
import com.lycanitesmobs.plainsmobs.dispenser.DispenserBehaviorQuill;
import com.lycanitesmobs.plainsmobs.entity.EntityFeradon;
import com.lycanitesmobs.plainsmobs.entity.EntityKobold;
import com.lycanitesmobs.plainsmobs.entity.EntityMaka;
import com.lycanitesmobs.plainsmobs.entity.EntityMakaAlpha;
import com.lycanitesmobs.plainsmobs.entity.EntityMorock;
import com.lycanitesmobs.plainsmobs.entity.EntityQuill;
import com.lycanitesmobs.plainsmobs.entity.EntityQuillbeast;
import com.lycanitesmobs.plainsmobs.entity.EntityRoc;
import com.lycanitesmobs.plainsmobs.entity.EntityVentoraptor;
import com.lycanitesmobs.plainsmobs.entity.EntityZoataur;
import com.lycanitesmobs.plainsmobs.item.ItemPlainsEgg;
import com.lycanitesmobs.plainsmobs.item.ItemQuill;
import com.lycanitesmobs.plainsmobs.item.ItemScepterQuill;
import com.lycanitesmobs.plainsmobs.mobevent.MobEventWindStorm;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="plainsmobs", name="Lycanites Plains Mobs", version="1.17.1.2 - MC 1.11.2", dependencies="required-after:lycanitesmobs", acceptedMinecraftVersions="[1.11.2]")
public class PlainsMobs {
    public static final String modid = "plainsmobs";
    public static final String name = "Lycanites Plains Mobs";
    public static GroupInfo group;
    @Mod.Instance(value="plainsmobs")
    public static PlainsMobs instance;
    @SidedProxy(clientSide="com.lycanitesmobs.plainsmobs.ClientSubProxy", serverSide="com.lycanitesmobs.plainsmobs.CommonSubProxy")
    public static CommonSubProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        group = new GroupInfo(this, "Plains Mobs", 0).setDimensionBlacklist("-1,1").setBiomes("PLAINS, SAVANNA, -SNOWY").setDungeonThemes("PLAINS, DUNGEON").setEggName("plainsspawn");
        group.loadFromConfig();
        ObjectManager.setCurrentGroup(group);
        ObjectManager.addItem("plainsspawn", new ItemPlainsEgg());
        ObjectManager.addItem("quill", new ItemQuill());
        ObjectManager.addItem("quillscepter", new ItemScepterQuill(), 2, 1, 1);
        ObjectManager.addItem("makameatraw", (Item)new ItemCustomFood("makameatraw", group, 2, 0.5f, ItemCustomFood.FOOD_CLASS.RAW).setPotionEffect(MobEffects.field_76437_t, 45, 2, 0.8f));
        ObjectLists.addItem("rawmeat", ObjectManager.getItem("makameatraw"));
        OreDictionary.registerOre((String)"listAllporkraw", (Item)ObjectManager.getItem("makameatraw"));
        ObjectManager.addItem("makameatcooked", (Item)new ItemCustomFood("makameatcooked", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.COOKED).setPotionEffect(MobEffects.field_76444_x, 10, 2, 1.0f).setAlwaysEdible());
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("makameatcooked"));
        OreDictionary.registerOre((String)"listAllporkcooked", (Item)ObjectManager.getItem("makameatcooked"));
        ObjectManager.addItem("bulwarkburger", new ItemCustomFood("bulwarkburger", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.MEAL).setPotionEffect(MobEffects.field_76444_x, 60, 2, 1.0f).setAlwaysEdible().func_77625_d(16), 3, 1, 6);
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("bulwarkburger"));
        ObjectManager.addItem("ventoraptortreat", new ItemTreat("ventoraptortreat", group));
        ObjectManager.addItem("roctreat", new ItemTreat("roctreat", group));
        ObjectManager.addItem("feradontreat", new ItemTreat("feradontreat", group));
        ObjectManager.addItem("quillbeasttreat", new ItemTreat("quillbeasttreat", group));
        ObjectManager.addItem("morocktreat", new ItemTreat("morocktreat", group));
        BlockDispenser.field_149943_a.func_82595_a((Object)ObjectManager.getItem("plainsspawn"), (Object)new DispenserBehaviorMobEggCustom());
        MobInfo newMob = new MobInfo(group, "kobold", EntityKobold.class, 0x996633, 0xFF7777).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(0).addSubspecies(new Subspecies("ashen", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(8).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "ventoraptor", EntityVentoraptor.class, 0x99BBFF, 13311).setPeaceful(false).setTameable(true).setSummonCost(4).setDungeonLevel(0).addSubspecies(new Subspecies("ashen", "uncommon")).addSubspecies(new Subspecies("azure", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(5).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "maka", EntityMaka.class, 0xAA8855, 0x221100).setPeaceful(true).setSummonCost(2).setDungeonLevel(-1).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("CREATURE").setDespawn(false).setSpawnWeight(10).setAreaLimit(10).setGroupLimits(2, 5).setLightDark(true, false).setDungeonWeight(0);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "makaalpha", EntityMakaAlpha.class, 0x663300, 0).setPeaceful(false).setSummonCost(4).setDungeonLevel(-1).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("").setDespawn(false).setSpawnWeight(1).setAreaLimit(4).setGroupLimits(1, 2).setLightDark(true, false).setDungeonWeight(0);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "zoataur", EntityZoataur.class, 0x442200, 0xFFDDBB).setPeaceful(false).setSummonable(true).setSummonCost(4).setDungeonLevel(2).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("light", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(4).setAreaLimit(4).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "roc", EntityRoc.class, 0xAA0000, 56644).setPeaceful(false).setTameable(true).setSummonCost(4).setDungeonLevel(2).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("scarlet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("SKY").setSpawnWeight(4).setAreaLimit(3).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "feradon", EntityFeradon.class, 14983741, 5582094).setPeaceful(false).setTameable(true).setSummonCost(4).setDungeonLevel(1).addSubspecies(new Subspecies("ashen", "uncommon")).addSubspecies(new Subspecies("scarlet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(5).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "quillbeast", EntityQuillbeast.class, 6564370, 6312446).setPeaceful(false).setTameable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("dark", "uncommon")).addSubspecies(new Subspecies("light", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(5).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "morock", EntityMorock.class, 0x222211, 0x554444).setPeaceful(false).setTameable(true).setSummonCost(8).setDungeonLevel(3).addSubspecies(new Subspecies("light", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("SKY").setSpawnWeight(1).setAreaLimit(1).setGroupLimits(1, 1).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        ObjectManager.addProjectile("quill", EntityQuill.class, ObjectManager.getItem("quill"), new DispenserBehaviorQuill());
        proxy.registerRenders(group);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MobInfo.loadAllFromConfigs(group);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ObjectManager.setCurrentGroup(group);
        ConfigBase config = ConfigBase.getConfig(group, "spawning");
        if (MobInfo.getFromName("roc") != null) {
            MobEventWindStorm mobEvent = new MobEventWindStorm("windstorm", group);
            SpawnTypeBase eventSpawner = new SpawnTypeSky("windstorm").setChance(1.0).setBlockLimit(32).setMobLimit(3);
            eventSpawner.materials = new Material[]{Material.field_151579_a};
            eventSpawner.ignoreBiome = true;
            eventSpawner.ignoreLight = true;
            eventSpawner.forceSpawning = true;
            eventSpawner.ignoreMobConditions = true;
            eventSpawner.addSpawn(MobInfo.getFromName("roc"));
            mobEvent.addSpawner(eventSpawner);
            MobEventManager.instance.addWorldEvent(mobEvent);
        }
        Biome[] biomes = PlainsMobs.group.biomes;
        if (PlainsMobs.group.controlVanillaSpawns) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityPig.class, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityChicken.class, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("bulwarkburger"), 1, 0), new Object[]{Items.field_151025_P, ObjectManager.getItem("makameatcooked"), Items.field_151025_P}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("makameatcooked"), 1, 0), new Object[]{ObjectManager.getItem("bulwarkburger")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("ventoraptortreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), ObjectManager.getItem("makameatcooked"), Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("roctreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), Items.field_179556_br, Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("feradontreat"), 4, 0), new Object[]{" RC", "BBT", " MP", Character.valueOf('T'), Items.field_151083_be, Character.valueOf('C'), Items.field_151077_bg, Character.valueOf('P'), Items.field_151157_am, Character.valueOf('M'), Items.field_179557_bn, Character.valueOf('R'), Items.field_179559_bp, Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("morocktreat"), 4, 0), new Object[]{"TTT", "TDT", "TTT", Character.valueOf('T'), ObjectManager.getItem("makameatcooked"), Character.valueOf('D'), Items.field_151045_i}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("quillbeasttreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), Items.field_151172_bF, Character.valueOf('B'), Items.field_151120_aE}));
        if (ItemInfo.enableWeaponRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("quillscepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("quill"), Character.valueOf('R'), Items.field_151072_bj}));
        }
        GameRegistry.addSmelting((Item)ObjectManager.getItem("makameatraw"), (ItemStack)new ItemStack(ObjectManager.getItem("makameatcooked"), 1), (float)0.5f);
    }
}

